IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Prod_Familias_Cupo') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Prod_Familias_Cupo
END
GO

CREATE FUNCTION [dbo].[CF_Prod_Familias_Cupo] 
(		@pId_Familia				INT
		,@pId_Prod_Familia_Sala		INT
		,@pId_Prod_Familia_Horario	INT
		,@pId_Producto				CHAR(14)
)		
RETURNS INT
AS
BEGIN
	DECLARE @Flag_Valida_Cupo	TINYINT
			,@Cupo INT

	SELECT @Flag_Valida_Cupo = Flag_Valida_Cupo FROM Prod_Familias WHERE Id_Familia = @pId_Familia

	IF @Flag_Valida_Cupo = 0
	   RETURN 0

	IF @Flag_Valida_Cupo = 1  --Por Sala
	BEGIN
		SELECT @Cupo = S.Cupo FROM Prod_Familias_Salas S WHERE S.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
		RETURN ISNULL(@Cupo,0)
	END

	IF @Flag_Valida_Cupo = 2  --Por Sala Y Horario
	BEGIN
		SELECT @Cupo = S.Cupo FROM Prod_Familias_Horarios_Salas S WHERE S.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala AND S.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
		RETURN ISNULL(@Cupo,0)
	END

	IF @Flag_Valida_Cupo = 3  --Por Sala Y Producto
	BEGIN
		SELECT @Cupo = S.Cupo FROM Prod_Salas S WHERE S.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala AND S.Id_Producto = @pId_Producto
		RETURN ISNULL(@Cupo,0)
	END

	IF @Flag_Valida_Cupo = 4  --Por Sala , Producto y Horario
	BEGIN
		--falta la tabla
		RETURN ISNULL(@Cupo,0)
	END

	IF @Flag_Valida_Cupo = 5  --Por Producto y Horario
	BEGIN
		SELECT @Cupo = S.Cupo FROM Prod_Horarios S WHERE S.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario AND S.Id_Producto = @pId_Producto
		RETURN ISNULL(@Cupo,0)
	END

	IF @Flag_Valida_Cupo = 6  --Por Horario
	BEGIN
		SELECT @Cupo = S.Cupo FROM Prod_Familias_Horarios S WHERE S.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
		RETURN ISNULL(@Cupo,0)
	END
	
	IF @Flag_Valida_Cupo = 7  --Por Horario
	BEGIN
		SELECT @Cupo = S.Cupo FROM Prod_Familias S WHERE S.Id_Familia = @pId_Familia
		RETURN ISNULL(@Cupo,0)
	END

	IF @Flag_Valida_Cupo = 8  --Por Producto 20220816
	BEGIN
		SELECT @Cupo = S.Cupo FROM Productos S WHERE S.Id_Producto = @pId_Producto
		RETURN ISNULL(@Cupo,0)
	END

	RETURN ISNULL(@Cupo,0)
END	
		
    